
jQuery(function($){
  function renumber(){
    $('#hqui-questions .hqui-q').each(function(i){
      $(this).attr('data-index', i);
      $(this).find('.hqui-q-no').text(i+1);
      $(this).find('input,textarea').each(function(){
        var name = $(this).attr('name');
        if(!name) return;
        name = name.replace(/hqui\[questions]\[\d+]/,'hqui[questions]['+i+']');
        $(this).attr('name', name);
      });
    });
  }
  $('#hqui-add-q').on('click', function(){
    var tpl = $('#hqui-q-template').html();
    var idx = $('#hqui-questions .hqui-q').length;
    tpl = tpl.replace(/__INDEX__/g, idx).replace('{{n}}', idx+1);
    $('#hqui-questions').append(tpl);
    renumber();
  });
  $('#hqui-questions').on('click','.hqui-remove-q', function(){
    $(this).closest('.hqui-q').remove();
    renumber();
  });

  // Media uploader
  $(document).on('click', '.hqui-media-select', function(e){
    e.preventDefault();
    var wrap = $(this).closest('.hqui-media');
    var frame = wp.media({ title: 'Görsel Seç', button: { text: 'Seç' }, multiple: false });
    frame.on('select', function(){
      var att = frame.state().get('selection').first().toJSON();
      wrap.find('.hqui-media-id').val(att.id);
      var url = (att.sizes && att.sizes.medium) ? att.sizes.medium.url : att.url;
      wrap.find('.hqui-media-preview').html('<img src="'+url+'" style="max-width:100%;height:auto;border:1px solid #eee;border-radius:6px;">');
    });
    frame.open();
  });
  $(document).on('click', '.hqui-media-remove', function(e){
    e.preventDefault();
    var wrap = $(this).closest('.hqui-media');
    wrap.find('.hqui-media-id').val('');
    wrap.find('.hqui-media-preview').empty();
  });
});
