
(function(){
  function create(tag, cls){ const el = document.createElement(tag); if(cls) el.className=cls; return el; }
  document.addEventListener('DOMContentLoaded', function(){
    document.querySelectorAll('.bq-wrap').forEach(function(root){
      const quiz = JSON.parse(root.getAttribute('data-quiz') || "{}");
      const intro = root.querySelector('.bq-intro');
      const h = intro.querySelector('h2');
      const p = intro.querySelector('p');
      const startBtn = root.querySelector('.bq-start');
      const form = root.querySelector('.bq-form');
      const stepsBox = root.querySelector('.bq-steps');
      const prevBtn = root.querySelector('.bq-prev');
      const nextBtn = root.querySelector('.bq-next');
      const submitBtn = root.querySelector('.bq-submit');
      const resultBox = root.querySelector('.bq-result');
      const bar = root.querySelector('.bq-bar');

      const title = quiz.intro_title || '';
      const desc = quiz.intro_desc || '';
      const questions = quiz.questions || [];
      const results = quiz.results || {};
      const tieOrder = Array.isArray(quiz.tie_break_order) ? quiz.tie_break_order : ['A','B','C','D'];

      h.textContent = title;
      p.textContent = desc;

      let i=0;
      const answers = new Array(questions.length).fill(null);

      function renderStep(index){
        stepsBox.innerHTML = "";
        const q = questions[index];
        if(!q){ return; }
        const step = create('fieldset','bq-step');
        const legend = create('legend','bq-q');
        legend.textContent = q.q || '';
        step.appendChild(legend);

        const optsWrap = create('div','bq-options');
        (q.opts||[]).forEach(function(opt, oi){
          const id = `bq_${index}_${oi}_${Math.random().toString(36).slice(2,7)}`;
          const label = create('label');
          const input = create('input');
          input.type = 'radio';
          input.name = `q${index}`;
          input.value = opt.k;
          input.id = id;
          input.required = true;
          label.setAttribute('for', id);
          label.appendChild(input);
          label.appendChild(document.createTextNode(opt.t));
          if(answers[index] === opt.k) input.checked = true;
          optsWrap.appendChild(label);
        });
        step.appendChild(optsWrap);
        stepsBox.appendChild(step);

        prevBtn.disabled = (index === 0);
        nextBtn.style.display = (index < questions.length - 1) ? '' : 'none';
        submitBtn.style.display = (index === questions.length - 1) ? '' : 'none';

        const filled = answers.filter(Boolean).length;
        const prog = Math.round(100 * (index / questions.length));
        bar.style.width = (filled === questions.length ? 100 : prog) + '%';
      }

      function getCurrentChoice(){
        const checked = stepsBox.querySelector('input[type=radio]:checked');
        return checked ? checked.value : null;
      }

      function computeMajority(){
        const counts = {};
        tieOrder.forEach(k => counts[k]=0);
        answers.forEach(k => { if(k && (k in counts)) counts[k]++; });
        let bestKey = tieOrder[0], bestVal=-1;
        tieOrder.forEach(k=>{ if(counts[k]>bestVal){ bestVal=counts[k]; bestKey=k; } });
        return bestKey;
      }

      startBtn && startBtn.addEventListener('click', function(){
        intro.style.display='none';
        form.style.display='block';
        renderStep(i);
        if(window.gtag){ gtag('event','quiz_start',{event_category:'quiz',event_label:'balor_quiz'}); }
      });

      nextBtn && nextBtn.addEventListener('click', function(){
        const checked = stepsBox.querySelector('input[type=radio]:checked');
        if(!checked){ alert('Lütfen bir seçenek seçin.'); return; }
        answers[i] = checked.value;
        i++; renderStep(i);
      });

      prevBtn && prevBtn.addEventListener('click', function(){
        i = Math.max(0, i-1);
        renderStep(i);
      });

      form && form.addEventListener('submit', function(e){
        e.preventDefault();
        const checked = stepsBox.querySelector('input[type=radio]:checked');
        if(!checked){ alert('Lütfen bir seçenek seçin.'); return; }
        answers[i] = checked.value;
        if(answers.some(a=>!a)){ alert('Tüm soruları yanıtlayın.'); return; }

        const key = computeMajority();
        const r = results[key] || null;
        form.style.display='none';
        resultBox.style.display='block';
        // add a gentle pop animation on show
        resultBox.classList.remove('bq-anim-pop');
        void resultBox.offsetWidth; // reflow for restart
        resultBox.classList.add('bq-anim-pop');
        resultBox.addEventListener('animationend', function onEnd(){ resultBox.classList.remove('bq-anim-pop'); resultBox.removeEventListener('animationend', onEnd); });

        if(r){
          resultBox.innerHTML = `
            <h3>${r.title||'Sonucun'}</h3>
            <p>${r.desc||''}</p>
            ${r.image ? `<img src="${r.image}" alt="${r.title||''}" class="bq-result-image">` : ''}
            <div class="bq-share">
              <a target="_blank" rel="noopener" href="https://twitter.com/intent/tweet?text=${encodeURIComponent('Benim sonucum: '+(r.title||''))}&url=${encodeURIComponent(location.href)}">X’te Paylaş</a>
              <a target="_blank" rel="noopener" href="https://www.facebook.com/sharer/sharer.php?u=${encodeURIComponent(location.href)}">Facebook’ta Paylaş</a>
              <button type="button" class="bq-copy">Linki Kopyala</button>
              <button type="button" class="bq-retry">Tekrar Dene</button>
            </div>`;
        } else {
          resultBox.textContent = 'Sonuç bulunamadı.';
        }

        resultBox.addEventListener('click', function(ev){
          if(ev.target.classList.contains('bq-copy')){
            navigator.clipboard.writeText(location.href);
            ev.target.textContent='Kopyalandı!';
          }
          if(ev.target.classList.contains('bq-retry')){
            i=0; for(let j=0;j<answers.length;j++) answers[j]=null;
            resultBox.style.display='none';
            form.style.display='block';
            renderStep(0);
          }
        }, {once:true});

        if(window.gtag){
          gtag('event','quiz_complete',{event_category:'quiz',event_label:'balor_quiz'});
          gtag('event','quiz_result',{event_category:'quiz',event_label:'balor_quiz', value: key});
        }
      });
    });
  });
})();
